unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, TAGraph, TASeries, Forms, Controls, Graphics,
  Dialogs, Menus, StdCtrls,Math, Types;

type

  { TForm1 }          { описание компонентов и событий }

  TForm1 = class(TForm)
    Button1: TButton;        { кнопка }
    Chart1: TChart;           { панель для создания диаграммы }
    Chart1BarSeries1: TBarSeries;   { тип диаграммы }
    Chart1LineSeries1: TLineSeries;
    Label1: TLabel;                  { надписи полей }
    Label2: TLabel;
    MainMenu1: TMainMenu;           { компонент добавления главного меню }
    Memo1: TMemo;                     { поля ввода и вывода }
    Memo2: TMemo;
    MenuItem1: TMenuItem;             { компоненты для ввода списка главного меню }
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    OpenDialog1: TOpenDialog;          { компонент операции открытия файла }
    SaveDialog1: TSaveDialog;           { компонент операции сохранения в файл }
    procedure Button1Click(Sender: TObject); { процедура по нажатию ОК }
    procedure Chart1BarSeries1BeforeDrawBar(ASender: TBarSeries;
      ACanvas: TCanvas; const ARect: TRect; APointIndex, AStackIndex: Integer;
      var ADoDefaultDrawing: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);   { процедура по нажатию Открыть файл }
    procedure MenuItem4Click(Sender: TObject);   { процедура по нажатию Сохранить файл }
    procedure MenuItem5Click(Sender: TObject);
    procedure MenuItem6Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var            { описание глобальных переменных }
  Form1: TForm1;
  s,q:string;
  h: array of integer;
  i,n:integer;
implementation

{$R *.lfm}

{ TForm1 }                { нахождение среднего арифметического }

function sred_arifmet(): Real;
var rt1:real; i:integer;      { описание локальных переменных }
begin
 rt1:=0;                       { присваиваем начальному значению 0 }
for i:=0 to n do
   rt1:=rt1+h[i];              { прибавляем начальному значению i того элемента массива }
   rt1:=rt1/(n+1);              { делим получившуюся сумму на количество элементов массива }
sred_arifmet:=rt1;
end;

function sred_geometr(): double;    { нахождение среднего геометрического }
var rt:real; i:integer;             { описание локальных переменных }
begin
rt:=1;                              { присваиваем начальному значению 1 }
  for i:=0 to n do
   rt:=rt*h[i];                     { умножаем начальное значение на i тый элемент массива }
   rt:=Power(rt,1/(n+1));           { возводим rt в степень 1/(n+1) }
   sred_geometr:=rt;
end;

function standart_otklonenie(): double;  { нахождение стандартного отклонения }
var rt:real; i:integer;                   { описание локальных переменных }
begin
rt:=0;
  for i:=0 to n do
   rt:=rt+sqr(h[i]-sred_arifmet);
   standart_otklonenie:=sqrt(rt/n);       { присваиваем конечному значению rt имени стандартного отклонения }

end;
function dispersia(): double;  { нахождение стандартного отклонения }
var rt:real; i:integer;                   { описание локальных переменных }
begin
rt:=0;
  for i:=0 to n do
   rt:=rt+sqr(h[i]-sred_arifmet);
   dispersia:=rt/n;

end;

procedure TForm1.MenuItem5Click(Sender: TObject);  { описание процедуры Выхода из программы через главное меню }
begin
  Close;
end;

procedure TForm1.MenuItem6Click(Sender: TObject);  { описание процедуры О программе через меню Справка }
begin
  ShowMessage('Программа'+#13#10+'Версия 1.00.0'); { Вывод информации диалогового окна }
end;

// Открыть файл
procedure TForm1.MenuItem3Click(Sender: TObject);   { описание процедуры Открытия файла через диалоговое окно }
begin
if opendialog1.Execute then
memo1.Lines.LoadFromFile(opendialog1.FileName);    { загружает данные в компонент Memo1 из указанного файла }
end;

//ОК
procedure TForm1.Button1Click(Sender: TObject);  { описание процедуры по нажаию кнопки Ок }
begin
n:=0;
S:=Memo1.Lines.DelimitedText;
 s:=StringReplace(s,',',' ',[rfReplaceAll{заменяем все вхождения}, rfIgnoreCase{игнорируем регистр при поиске}]);
 s:=StringReplace(s,'"','',[rfReplaceAll{заменяем все вхождения}, rfIgnoreCase{игнорируем регистр при поиске}]);
 s:=StringReplace(s,'   ',' ',[rfReplaceAll{заменяем все вхождения}, rfIgnoreCase{игнорируем регистр при поиске}]);
 s:=StringReplace(s,'  ',' ',[rfReplaceAll{заменяем все вхождения}, rfIgnoreCase{игнорируем регистр при поиске}]);
 s:=trim(s);
  if length(s)>0 then
  begin
 s:=s+' ';
  for i:=1 to length(s) do

   if s[i]<>' ' then q:=q+s[i] else
     begin
       n:=n+1;
       SetLength(h, n);
       h[n-1]:=strtoint(q);
       q:='';
       end;
       n:=n-1;

   Memo2.clear;        { очищаем поле }

   Memo2.Lines.Add('Cреднее арифметическое: '+floattostr(sred_arifmet));   { добавляем строку и выводим в нее значения присвоенные переменным }
    Memo2.Lines.Add('Cреднее геометрическое: '+floattostr(sred_geometr));
     Memo2.Lines.Add('Cтандартное отклонение: '+floattostr(standart_otklonenie));
       Memo2.Lines.Add('Минимальное: '+floattostr(MinIntValue(h)));
        Memo2.Lines.Add('Максимальное: '+floattostr(MaxIntValue(h)));
          Memo2.Lines.Add('Дисперсия: '+floattostr(dispersia));
    Chart1barSeries1.Clear;                                                { очищаем серию от ранее внесенных данных }
    for i:=0 to n do
    Chart1barSeries1.AddXY(h[i],(1/dispersia*sqr(2*Pi)*Exp(-(i-sred_arifmet/2*sqrt(dispersia)))),IntToStr(i), clred);                    { добавляем в диаграмму новые точки массива }
    end;
end;

procedure TForm1.Chart1BarSeries1BeforeDrawBar(ASender: TBarSeries;
  ACanvas: TCanvas; const ARect: TRect; APointIndex, AStackIndex: Integer;
  var ADoDefaultDrawing: Boolean);
begin

end;

procedure TForm1.FormCreate(Sender: TObject);
begin

end;

// Сохранить файл
procedure TForm1.MenuItem4Click(Sender: TObject);   { описание процедуры ОСохранения в файл }
begin
 if savedialog1.Execute then
 memo2.Lines.SaveToFile(savedialog1.FileName);
end;

end.

